// eslint-disable-next-line no-unused-vars
const app = new Vue({
  el: '#app',
  data() {
    return {
      // 语言
      i18n: templateData,
      // 当前页
      pageActive: undefined,
      // 上一页
      pagePrev: undefined,
      pageVerifyPrev: undefined,
      // 标题和说明
      titleText: undefined,
      descText: undefined,
      // 登录方式
      accountType: 'email', // email, mobile
      // 是否自动填充的密码
      isAutoPassword: false,
      // 验证码
      sendCodeParams: {},
      sendCodeText: templateData.sendVerifyCode,
      sendCodeDisabled: false,
      sendCodeTimer: false,
      validDialogVisible: false,
      validDialogImg: '',
      validDialogInput: '',
      // 地址栏参数
      pageType: undefined,
      tempkey: undefined,
      // 获取数据
      browserInfo: {},
      clientData: {},
      accountList: [],
      currentAccount: {},
      guestAccount: undefined,
      // 滚动按钮
      scrollPrevVisible: false,
      scrollNextVisible: false,
      // 提交按钮和信息
      submitBtnText: undefined,
      submitBtnDisabled: false,
      submitCallbackText: undefined,
      // 设置
      settingVisible: false,
      // 选择备用线路
      backupLineVisible: false,
      // 表单：登录时需要提交的内容
      formdata: {
        email: undefined,
        mobile: undefined,
        vcode: undefined,
        password: undefined,
        password1: undefined,
        password2: undefined,
        isSavePassword: false,
        isAutoLogin: false,
        isExitClearData: false,
        isBackupLine: false
      },
      // 错误信息
      errorInfo: {
        email: undefined,
        mobile: undefined,
        vcode: undefined,
        password: undefined,
        password1: undefined,
        password2: undefined
      }
    };
  },
  watch: {
    // 切换页面
    'pageActive': function (n, o) {
      if (n === 'login') {
        this.pagePrev = o;
      }
      this.updatePageData();
    },
    // 取消记住密码，必须取消自动登录
    'formdata.isSavePassword': function (n) {
      if (!n) {
        this.formdata.isAutoLogin = false;
      }
    },
    // 选中自动登录，必须选中记住密码
    'formdata.isAutoLogin': function (n) {
      if (n) {
        this.formdata.isSavePassword = true;
      }
    }
  },
  created() {
    const paramsStr = window.location.search;
    const params = new URLSearchParams(paramsStr);
    this.pageType = params.get('type');
    this.tempkey = params.get('tempkey');
    this.initPage();
  },
  mounted() {
    // 初始化电话插件
    this.intlTelInput();
    // 按下Enter键提交
    window.addEventListener('keyup', e => {
      if (e.code === 'Enter' || e.code === 'NumpadEnter') {
        this.handleSubmit();
      }
    });
    // 滚动账号列表时
    const $userList = document.getElementById('userList');
    $userList.addEventListener('scroll', () => {
      this.scrollPrevVisible = $userList.scrollTop > 0;
      this.scrollNextVisible = $userList.scrollTop < $userList.scrollHeight - $userList.offsetHeight;
    });
    // 客户端关闭页面
    window.onClosePage = function () {
      this.clickGuestBtn();
    };
  },
  methods: {
    // 获取初始化数据
    async initPage() {
      this.browserInfo = api.getBrowserInfo();
      this.browserInfo.ip = await api.getIp();
      await this.getClientData();
      this.initAccount();
    },
    // 获取客户端保存的信息
    // isAccountGuest: true, isGuest: true 游客账号
    // isAccountGuest: true, isGuest: false 游客账号并且改过密码
    // isAccountGuest: false, isGuest: false 正常账号
    async getClientData() {
      this.clientData = await api.getClientData();
      // 账号列表
      this.guestAccount = undefined;
      this.accountList = [];
      this.clientData.accounts
        // 排除旧的游客账号、本地账号
        .filter(item => !item.isGuestAccount && !item.isLocalAccount)
        // 列表排序
        .forEach(item => {
          item.isSaved = true;
          if (item.isAccountGuest || item.isGuest) {
            // 新的游客账号放前边
            this.guestAccount = item;
            this.accountList.unshift(item);
          } else {
            // 普通账号放后边
            this.accountList.push(item);
          }
        });
      // 是否显示滚动按钮
      this.scrollNextVisible = this.accountList.length > 4;
      // 已注册的游客账号
      if (!this.guestAccount) {
        const resObj = await api.getLocalData('guset-account');
        if (resObj) {
          this.guestAccount = resObj;
          this.accountList.unshift(resObj);
        }
      }
    },
    // 初始化账号
    async initAccount() {
      // 区分打开类型
      if (this.pageType === 'close') {
        // 退出
        this.pageActive = this.accountList.length ? 'userList' : 'login';
        return;
      } else if (this.pageType === 'init') {
        // 初始化
        this.pageActive = 'login';
        return;
      }
      // 没有账号列表
      if (!this.accountList.length) {
        this.pageActive = 'login';
        return;
      }
      // 有账号列表但是没有当前账号
      if (!this.clientData.currentAccount) {
        if (this.guestAccount) {
          // 有游客打开列表
          this.pageActive = 'userList';
        } else {
          // 没有游客去注册
          this.regGuestAccount();
        }
        return;
      }
      // 有账号列表并且有当前账号
      const currentUser = this.accountList.find(n => n.account === this.clientData.currentAccount);
      // 当前账号不存在列表中
      if (!currentUser) {
        this.pageActive = 'userList';
        return;
      }
      // 当前账号存在列表中
      this.pageActive = currentUser.isGuest ? 'userList' : 'userLogin';
      if (currentUser.isAutoLogin) {
        // 自动登录
        this.selectAccount(currentUser);
        this.loginByAccount(true);
      } else if (currentUser.isGuest) {
        // 不自动登录：游客账号不处理
      } else {
        // 不自动登录：普通账号选中
        this.selectAccount(currentUser);
      }
    },
    // 点击账号列表中的一项
    clickAccountItem(item) {
      this.selectAccount(item);
      if (item.isGuest) {
        // 游客：自动登录
        this.loginByAccount();
      } else {
        // 其它：输入密码
        this.pageActive = 'userLogin';
      }
    },
    // 点击游客登录按钮
    async clickGuestBtn() {
      if (this.submitBtnDisabled) return;
      this.submitBtnDisabled = true;
      if (this.guestAccount) {
        // 本地有记录：说明已注册，不论是否修改过密码，都不登录
        api.setlog('点击游客按钮', { data: '不登录' });
        api.useTouristAccount();
        api.closeWindow();
      } else {
        // 本地没有记录：先注册，查询到结果后再处理
        this.regGuestAccount();
      }
    },
    // 游客注册
    async regGuestAccount() {
      this.submitBtnDisabled = true;
      // 服务端接口
      const res = await api.regGuest({
        ip: this.browserInfo.ip,
        device: this.browserInfo.device,
        password: this.browserInfo.device_hash
      });
      // 注册失败
      if (res.code) {
        this.pageActive = 'login';
        this.submitBtnDisabled = false;
        this.errorInfo.password = res.msg;
        return;
      }
      // 注册结果解密
      const decodeParams = {
        data: res.data,
        password: this.browserInfo.device_hash,
        isSavePassword: true,
        isAutoLogin: true,
        isExitClearData: false,
        isGuest: true,
        isAccountGuest: true
      };
      const decodeResObj = await api.clientLogin(decodeParams);
      // 处理注册结果
      if (decodeResObj.code === 0 || decodeResObj.data.code === 100) {
        // 注册成功/已注册过
        this.pageActive = 'userLogin';
        this.selectAccount({
          account: decodeResObj.data.account,
          hash: this.browserInfo.device_hash,
          isSavePassword: true,
          isAutoLogin: true,
          isExitClearData: false,
          isGuest: true,
          isAccountGuest: true
        });
        this.loginSubmit({
          isDefaultLogin: false,
          account: this.currentAccount.account,
          country: this.currentAccount.country,
          isGuest: this.currentAccount.isGuest,
          isAccountGuest: this.currentAccount.isAccountGuest
        });
      } else {
        // 注册失败
        this.submitBtnDisabled = false;
        this.errorInfo.password = decodeResObj.msg || decodeResObj.data.msg;
      }
    },
    // 选择账号
    selectAccount(selectedAccount) {
      api.setlog('选择用户', selectedAccount);
      this.currentAccount = selectedAccount;
      this.isAutoPassword = selectedAccount.isSavePassword && this.currentAccount.hash;
      this.formdata.password = selectedAccount.isSavePassword ? this.currentAccount.hash : '';
      this.formdata.isSavePassword = selectedAccount.isSavePassword;
      this.formdata.isAutoLogin = selectedAccount.isAutoLogin;
      this.formdata.isExitClearData = selectedAccount.isExitClearData;
    },
    // 选择账号后登录
    loginByAccount(isDefaultLogin) {
      // 普通账号校验密码失败
      if (!this.currentAccount.isGuest && !this.validPasswordFormat('password')) {
        api.openWindow();
        return false;
      }
      // 成功
      this.loginSubmit({
        isDefaultLogin,
        account: this.currentAccount.account,
        country: this.currentAccount.country,
        isGuest: this.currentAccount.isGuest,
        isAccountGuest: this.currentAccount.isAccountGuest
      });
    },
    // 输入账号后登录
    loginByInput() {
      if (!this.validAccountFormat()) {
        return false;
      }
      if (!this.validPasswordFormat('password')) {
        return false;
      }
      this.loginSubmit({
        isDefaultLogin: false,
        account: this.formdata[this.accountType],
        country: this.accountType === 'mobile' ? $('.iti__selected-dial-code').text().replace('+', '') : '',
        isGuest: false,
        isAccountGuest: false
      });
    },
    // 登录提交
    async loginSubmit(params) {
      this.submitBtnText = this.i18n.loginLoading;
      this.submitBtnDisabled = true;
      this.errorInfo.password = '';
      const pass = this.isAutoPassword ? this.formdata.password : this.getHashCode(this.formdata.password);
      // 服务端接口
      const loginParams = {
        // 表单信息
        account: params.account,
        country: params.country,
        password: pass,
        // 浏览器信息
        ip: this.browserInfo.ip,
        ver: this.browserInfo.version,
        os: this.browserInfo.os,
        device: this.browserInfo.device,
        device_name: this.browserInfo.device_name,
        region: this.browserInfo.region,
        language: navigator.language,
        // 固定信息
        app: 'mx3',
        package_id: '',
        product_type: ''
      };
      // if (this.currentAccount.isGuest || params.isGuest) {
      //   // 游客不传，改了密码的游客按非游客处理
      // } else if (this.currentAccount.isSaved && this.formdata.isAutoLogin) {
      //   // 非游客：本地有记录、并且是自动登录才传
      //   loginParams.type = 'silent';
      // }
      const loginRes = await api.accountLogin(loginParams, this.formdata.isBackupLine);
      api.setlog('登录结果', loginRes);
      // 网络错误时
      if (loginRes.code === 201) {
        // 自动登录
        if (this.formdata.isAutoLogin) {
          if (!this.formdata.isBackupLine) {
            // 未使用备用线路：自动切换备用线路重新登录
            this.formdata.isBackupLine = true;
            this.loginSubmit(params);
            return;
          } else if (params.isDefaultLogin) {
            // 已使用备用线路：如果是默认登录直接关闭窗口
            api.closeWindow();
            return;
          } else {
            // 已使用备用线路：如果是手动选择的登录显示网络错误
          }
        }
        // 不是自动登录：显示网络错误
        this.submitBtnText = this.i18n.loginBtn;
        this.submitBtnDisabled = false;
        this.backupLineVisible = true;
        this.errorInfo.password = loginRes.msg;
        api.openWindow();
        return;
      }
      // 登录结果解密
      const decodeParams = {
        data: loginRes.data,
        account: params.account,
        password: pass,
        isSavePassword: this.formdata.isSavePassword,
        isAutoLogin: this.formdata.isAutoLogin,
        isExitClearData: this.formdata.isExitClearData,
        isGuest: params.isGuest,
        isAccountGuest: params.isAccountGuest
      };
      const decodeResObj = await api.clientLogin(decodeParams);
      // 处理登录结果
      this.submitBtnText = this.i18n.loginBtn;
      this.submitBtnDisabled = false;
      if (decodeResObj.code === 0) {
        // 登录成功
        api.closeWindow();
      } else {
        // 登录失败
        this.backupLineVisible = decodeResObj.code === 201;
        this.errorInfo.password = decodeResObj.msg || decodeResObj.data.msg;
        api.openWindow();
        // 游客并改了密码，转成非游客
        if (this.currentAccount.isGuest) {
          this.currentAccount.isSavePassword = false;
          this.currentAccount.isAutoLogin = false;
          this.currentAccount.isGuest = false;
          this.currentAccount.isAccountGuest = true;
          this.guestAccount = this.currentAccount;
          await api.saveLocalData('guset-account', this.currentAccount);
          this.getClientData();
        }
      }
    },
    // 获取该模块在此页面下的显示状态
    getVisible(pages) {
      return pages.indexOf(this.pageActive) > -1;
    },
    // 返回
    goBack() {
      if (this.pageActive === 'userLogin' && this.pagePrev === 'userList' && !this.accountList.length) {
        this.pagePrev = 'login';
      }
      if (this.pageActive === 'login' && this.pagePrev === 'userLogin') {
        api.setlog('点击返回按钮', { data: '返回用户登录' });
        this.selectAccount(this.currentAccount);
      }
      this.pageActive = this.pagePrev;
    },
    // 页面底部的登录其它账号
    useOtherAccount() {
      if (this.accountList.length > 1) {
        this.pageActive = 'userList';
      } else {
        this.pageActive = 'login';
      }
    },
    // 更新页面数据
    updatePageData() {
      // 地址栏路径
      const newUrl = this.pageActive === 'login' ? '/' : this.pageActive;
      window.history.replaceState({}, document.title, newUrl + location.search);
      // 标题/说明/按钮文案
      const str = this.pageActive.replace('Verify', '').replace('Password', '');
      this.titleText = this.i18n[`${str}Title`];
      this.descText = this.i18n[`${str}TitleInfo`];
      this.submitBtnText = this.i18n[`${str}Btn`];
      // 获取焦点
      this.$nextTick(() => {
        $('.mx-input:visible:first').focus();
      });
      // 其它
      switch (this.pageActive) {
        case 'login': // 登录
          this.pageVerifyPrev = 'login';
          this.accountType = 'email';
          this.currentAccount.avatarUrl = './img/avatar-login.svg';
          this.handleReset('email,mobile,password,toolbar');
          break;
        case 'userList': // 用户列表
          this.pagePrev = 'login';
          this.accountType = undefined;
          this.currentAccount.avatarUrl = undefined;
          break;
        case 'userLogin': // 用户登录
          this.pagePrev = 'userList';
          this.pageVerifyPrev = 'userLogin';
          this.accountType = undefined;
          this.submitBtnText = this.i18n.loginBtn;
          break;
        case 'registerVerify': // 注册校验
        case 'recoveryVerify': // 找回校验
          this.pagePrev = this.pageVerifyPrev;
          this.accountType = 'email';
          this.currentAccount.avatarUrl = './img/avatar-register.png';
          this.submitBtnText = this.i18n.nextStep;
          this.handleReset('email,mobile,vcode');
          break;
        case 'registerPassword': // 注册提交
        case 'recoveryPassword': // 找回提交
          this.pagePrev = `${str}Verify`;
          this.handleReset('password1,password2');
          break;
        default:
        // ...
      }
    },
    // 初始化电话插件
    intlTelInput() {
      const _this = this;
      $('#mobile').intlTelInput({
        separateDialCode: true,
        initialCountry: 'cn'
      });
      $('.iti input')
        .attr('placeholder', this.i18n.inputMobile)
        .on('input', function () {
          _this.formdata.mobile = $(this).val().trim();
        });
    },
    // 打开设置菜单
    handleOpenSetting() {
      this.settingVisible = true;
      this.$nextTick(() => {
        $('.mx-dropdown:visible').focus();
      });
    },
    // 点击提交
    handleSubmit() {
      switch (this.pageActive) {
        case 'login':
          this.loginByInput();
          break;
        case 'userLogin':
          this.loginByAccount();
          break;
        case 'userList':
          this.pageActive = 'login';
          break;
        case 'registerVerify':
        case 'recoveryVerify':
          this.handleVerifySubmit();
          break;
        case 'registerPassword':
        case 'recoveryPassword':
          this.handlePasswordSubmit();
          break;
      }
    },
    // 删除账号
    async handleLogoutSubmit(selectedAccount) {
      api.deleteAccount(selectedAccount.profilePath);
      // 是否需要删除本地存储的游客账号
      if (selectedAccount.account === this.guestAccount?.account) {
        await api.removeLocalData('guset-account');
      }
      // 重新获取列表
      await this.getClientData();
      // 是否需要返回首页
      if (this.accountList.length === 0) {
        this.pageActive = 'login';
      }
    },
    // 滚动列表
    handleScroll(size) {
      const $userList = $('#userList');
      $userList.animate(
        {
          scrollTop: `${$userList.scrollTop() + size}px`
        },
        100
      );
    },
    // 发送验证码
    clickSendBtn() {
      // 校验
      if (this.sendCodeDisabled) return;
      if (!this.validAccountFormat()) return;
      this.sendCodeDisabled = true;
      // 区分参数
      this.sendCodeParams = {
        tempkey: this.tempkey,
        code_id: this.pageActive === 'registerVerify' ? Math.random().toString(36).slice(2) + Date.now().toString(36) : `${this.formdata[this.accountType]}_resetpass`
      };
      if (this.accountType === 'mobile') {
        this.sendCodeParams.phone = this.formdata.mobile;
        this.sendCodeParams.country = $('.iti__selected-dial-code').text().replace('+', '');
      } else {
        this.sendCodeParams.email = this.formdata.email;
      }
      // 提交
      this.sendCode();
    },
    // 发送验证码-打开校验
    openValidDialog(cap) {
      this.validDialogVisible = true;
      this.validDialogImg = cap;
      this.validDialogInput = '';
      this.sendCodeParams.answer = '';
      this.sendCodeDisabled = false;
      this.errorInfo.vcode = undefined;
    },
    // 发送验证码-校验-刷新
    clickValidRefreshBtn() {
      this.validDialogInput = '';
      this.sendCodeParams.answer = '';
      this.errorInfo.vcode = undefined;
      this.sendCode();
    },
    // 发送验证码-校验-确定
    clickValidConfirmBtn() {
      this.sendCodeParams.answer = this.validDialogInput;
      this.errorInfo.vcode = undefined;
      this.sendCode();
    },
    // 发送验证码-校验-取消
    clickValidCancelBtn() {
      this.validDialogVisible = false;
      this.validDialogImg = '';
      this.validDialogInput = '';
      this.sendCodeParams.answer = '';
      this.errorInfo.vcode = undefined;
    },
    // 注册/找回-发送验证码
    async sendCode() {
      const res = await api.sendCode(this.sendCodeParams);
      if (res.code === 0) {
        this.validDialogVisible = false;
        this.errorInfo.vcode = undefined;
        this.setVcodeTimer();
      } else if (res.code === 101) {
        this.openValidDialog(res.cap);
      } else {
        this.sendCodeDisabled = false;
        this.errorInfo.vcode = res.msg || res.message;
      }
    },
    // 注册/找回-获取验证码-倒计时
    setVcodeTimer() {
      let timeout = 60;
      this.sendCodeTimer = setInterval(() => {
        this.sendCodeText = timeout + this.i18n.verifyCodeTimeout;
        timeout--;
        if (timeout < 0) {
          this.sendCodeText = this.i18n.sendVerifyCode;
          this.sendCodeDisabled = false;
          clearInterval(this.sendCodeTimer);
        }
      }, 1000);
    },
    // 注册/找回-校验验证码
    handleVerifySubmit() {
      // 校验
      if (!this.validAccountFormat()) return;
      if (!this.validVcodeFormat()) return;
      this.submitBtnDisabled = true;
      // 提交
      api
        .verifyCode({
          tempkey: this.tempkey,
          code: this.formdata.vcode,
          code_id: this.sendCodeParams.code_id
        })
        .then(res => {
          this.submitBtnDisabled = false;
          if (res.code === 0) {
            this.errorInfo.vcode = undefined;
            this.pageActive = this.pageActive.replace('Verify', 'Password');
          } else {
            this.errorInfo.vcode = res.msg || res.message;
          }
        });
    },
    // 注册/找回-提交
    async handlePasswordSubmit() {
      if (!this.validPasswordFormat('password1')) {
        return false;
      }
      if (this.formdata.password1 !== this.formdata.password2) {
        this.errorInfo.password2 = this.i18n.passwordInconsistency;
        return false;
      }
      this.submitBtnDisabled = true;
      const res = this.pageActive === 'registerPassword' ? await this.registerSubmit() : await this.resetSubmit();
      if (res.code === 0) {
        this.errorInfo.vcode = undefined;
        this.setSuccessTimer();
      } else {
        this.submitBtnDisabled = false;
        this.errorInfo.password2 = res.msg || res.message;
      }
    },
    // 注册提交
    async registerSubmit() {
      const countryCode = $('.iti__selected-dial-code').text().replace('+', '');
      const params = {
        tempkey: this.tempkey,
        account: this.formdata[this.accountType],
        country: this.accountType === 'mobile' ? countryCode : '',
        password: this.getHashCode(this.formdata.password2)
      };
      return api.registerAccount(params);
    },
    // 找回提交
    async resetSubmit() {
      const params = {
        tempkey: this.tempkey,
        account: this.formdata[this.accountType],
        code: this.formdata.vcode,
        new_password: this.getHashCode(this.formdata.password2)
      };
      return api.resetPass(params);
    },
    // 注册/找回-成功后跳转-倒计时
    setSuccessTimer() {
      let timeout = 3;
      const key = this.pageActive.replace('Password', 'Success');
      const timer = setInterval(() => {
        this.submitCallbackText = `${this.i18n[key]}(${timeout}s)`;
        timeout--;
        if (timeout < 0) {
          this.pageActive = this.pageVerifyPrev;
          this.submitBtnDisabled = false;
          this.submitCallbackText = undefined;
          clearInterval(timer);
        }
      }, 1000);
    },
    // 校验账号格式
    validAccountFormat() {
      if (this.accountType === 'email') {
        return this.validEmailFormat();
      } else {
        return this.validMobileFormat();
      }
    },
    // 校验邮箱格式
    validEmailFormat() {
      const reg = /^[a-zA-Z0-9+_.-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$/;
      if (reg.test(this.formdata.email)) {
        this.errorInfo.email = undefined;
        return true;
      } else {
        this.errorInfo.email = this.i18n.emailFormatError;
        return false;
      }
    },
    // 校验手机号格式
    validMobileFormat() {
      if (this.formdata.mobile) {
        this.errorInfo.mobile = undefined;
        return true;
      } else {
        this.errorInfo.mobile = this.i18n.mobileEmpty;
        return false;
      }
    },
    // 校验密码格式
    validPasswordFormat(key) {
      const password = this.formdata[key];
      if (!password) {
        this.errorInfo[key] = this.i18n.passwordEmptyError;
        return false;
      } else if (password.length < 2) {
        this.errorInfo[key] = this.i18n.passwordLengthError;
        return false;
      } else {
        this.errorInfo[key] = undefined;
        return true;
      }
    },
    // 校验验证码格式
    validVcodeFormat() {
      if (this.formdata.vcode) {
        this.errorInfo.vcode = undefined;
        return true;
      } else {
        this.errorInfo.vcode = this.i18n.enterVerifyCode;
        return false;
      }
    },
    // 重置表单和错误信息
    handleReset(keys) {
      keys.split(',').forEach(key => {
        if (key === 'toolbar') {
          this.formdata.isSavePassword = false;
          this.formdata.isAutoLogin = false;
          this.formdata.isExitClearData = false;
        } else {
          if (key === 'mobile') {
            $('.iti input').val('');
          }
          this.formdata[key] = undefined;
          this.errorInfo[key] = undefined;
        }
      });
    },
    // 获取密码的哈希值
    getHashCode(str) {
      // eslint-disable-next-line no-undef
      return str ? sha256(str) : '';
    }
  }
});
