class RestServiceReq{
    host="";
    userName = "";
    ajax_req (method, uri, content, succeed_cbk){
        let settings = {
            "async": true,
            "crossDomain": true,
            "url": this.host + uri,
            "method": method,
			"data":content,
            "headers": {
                "UserName": this.userName
            }
        }

        $.ajax(settings).done(function (response) {
            if(succeed_cbk) {
                succeed_cbk(response);
            }
            console.log(response);
        });
    }

    xhr_req (method, uri, content, succeed_cbk){
        let xhr = new XMLHttpRequest();
        xhr.withCredentials = false;

        xhr.addEventListener("readystatechange", function () {
            if (this.readyState === 4) {
                console.log(this.responseText);
                if(succeed_cbk){
                    succeed_cbk(this.responseText)
                }
            }
        });

        xhr.open(method, this.host + uri);
        xhr.setRequestHeader("UserName", this.userName);
        //xhr.setRequestHeader("cache-control", "no-cache");
        xhr.send(content);
    }

    onRSGetAddress(addr){
        this.host = addr
    }

    onRSGetProfile(p){
        this.userName = p.profile
    }

    init(){
        chrome.send('maxthon.getServiceAddress', ['RS.onRSGetAddress', 'MAXTHON_REST_SERVICE']);
        chrome.send('getCurrentUserProfile', ['RS.onRSGetProfile'])
    }
}

