/**************************************************/
/* filename: parse-svg.js                   */
/* author: zhsoft88                               */
/* date: 2011.5.6                                 */
/* copyright (c) 2011 maxthon internaltional ltd. */
/**************************************************/

function SVGResult()
{
  this.width = 0;
  this.height = 0;
  this.xscale = 1;
  this.yscale = 1;
  this.color = '#000000';
  this.paths = [];
}

function IsSVGSpace(c)
{
  return c == ' ' || c == '\r' || c == '\n';
}

function IsSVGDigit(c)
{
  return c == '.' || (c >= '0' && c <= '9');
}

function IsSVGPathKey(c)
{
  if (c >= 'a' && c <= 'z')
    return true;
  if (c >= 'A' && c <= 'Z')
    return true;
  return false;
}

function GetTransforms(g)
{
  var result = [];
  if (!g)
    return result;
  var t = g.getAttribute('transform');
  if (!t)
    return result;
  //
  var i = 0;
  while (i < t.length) {
    //skip space
    while (i < t.length && t[i] == ' ') {
      i++;
    }
    if (i == t.length)
      break;
    //get cmd
    var cmd = '';
    while (i < t.length && t[i] != '(') {
      cmd += t[i];
      i++; 
    }
    if (i == t.length)
      break;
    //skip (
    i++;
    if (i == t.length)
      break;
    //get args until )
    var args = [];
    while (i < t.length) {
      //skip space
      while (i < t.length && t[i] == ' ') {
        i++;
      }
      if (i == t.length)
        break;
      var arg = '';
      while (i < t.length) {
        if (t[i] == ' ' || t[i] == ',' || t[i] == ')')
          break;
        arg += t[i];
        i++;
      }
      if (i == t.length)
        break;
      args.push(parseFloat(arg));
      if (t[i] == ')') {
        i++;
        break;
      }
      if (t[i] == ',') {
        i++;
        continue;
      }
      //space
      i++;
      while (i < t.length && t[i] == ' ') {
        i++;
      }
      if (i == t.length)
        break;
      if (t[i] == ')') {
        i++;
        break;
      }
      if (t[i] == ',') {
        i++;
      }
    }
    result.push({cmd: cmd, args: args});
  }
  return result;
}

function ParseSVG(data)
{
  var result = new SVGResult;
  var doc = (new DOMParser).parseFromString(data, 'text/xml');
  var root = doc.documentElement;
  result.width = parseFloat(root.getAttribute('width'));
  result.height = parseFloat(root.getAttribute('height'));
  result.transforms = GetTransforms(doc.querySelector('g[id]'));
  //
  var path = doc.querySelector('path');
  result.stroke = path.getAttribute('stroke');
  result.strokeLineCap = path.getAttribute('stroke-linecap');
  result.strokeLineJoin = path.getAttribute('stroke-linejoin');
  result.strokeWidth = parseFloat(path.getAttribute('stroke-width'));
  result.fill = path.getAttribute('fill');
  //
  var d = path.getAttribute('d');
  var list = [];
  var i = 0;
  while (i < d.length) {
    //skip space
    while (i < d.length && IsSVGSpace(d[i])) {
        i++;
    }
    if (i == d.length)
      break;
    //get key
    var key = d[i];
    if (!IsSVGPathKey(key))
      throw "bad key: " + key;
    i++;
    //get args
    var args = [];
    while (i < d.length) {
      //skip space
      while (i < d.length && IsSVGSpace(d[i])) {
        i++;
      }
      if (i == d.length)
        break;
      if (IsSVGPathKey(d[i]))
        break;
      if (d[i] == '-' || IsSVGDigit(d[i])) {
        var arg = d[i];
        i++;
        while (i < d.length && IsSVGDigit(d[i])) {
          arg += d[i];
          i++;
        }
//        console.log('arg: '+arg)
        args.push(parseFloat(arg));
        if (i == d.length)
          break;
        if (IsSVGPathKey(d[i]))
          break;
        if (d[i] != '-')
          i++;
      } else {
        throw "bad arg: " + d[i];
      }
    }
    //console.log(key+', '+args)
    result.paths.push({key: key, args: args});
  }
  return result;
}

function SVGToCanvas(data)
{
  var result = ParseSVG(data);
  //
  var canvas = document.createElement('canvas');
  canvas.width = result.width;
  canvas.height = result.height;
  //
  var ctx = canvas.getContext('2d');
  ctx.strokeStyle = result.stroke;
  if (result.strokeLineCap)
    ctx.lineCap = result.strokeLineCap;
  if (result.strokeLineJoin)
    ctx.lineJoin = result.strokeLineJoin;
  if (result.strokeWidth)
    ctx.lineWidth =  parseFloat(result.strokeWidth);

  var fill = false;
  if (result.fill && result.fill != 'none') {
    ctx.fillStyle = result.fill;
    fill = true;
  }
  //
  for (var i = 0; i < result.transforms.length; i++) {
    var t = result.transforms[i];
    if (t.cmd == 'translate') {
      ctx.translate(t.args[0] || 0, t.args[1] || 0);
    } else if (t.cmd == 'scale') {
      ctx.scale(t.args[0] || 1, t.args[1] || 1);
    }
  }
  //
  var cx = cy = 0;
  var cx1 = cy1 = 0;
  var lastkey = '';
  for (var i = 0; i < result.paths.length; i++) {
    var key = result.paths[i].key;
    switch(key) {
    case 'M':
      cx = result.paths[i].args[0];
      cy = result.paths[i].args[1];
      ctx.beginPath();
      ctx.moveTo(cx, cy);
      break;
    case 'm':
      cx += result.paths[i].args[0];
      cy += result.paths[i].args[1];
      ctx.beginPath();
      ctx.moveTo(cx, cy);
      break;
    case 'Z':
    case 'z':
      ctx.closePath();
      if (fill) {
        ctx.fill();
      }
      ctx.stroke();
      break;
    case 'C':
      var x1 = result.paths[i].args[0];
      var y1 = result.paths[i].args[1];
      var x2 = result.paths[i].args[2];
      var y2 = result.paths[i].args[3];
      cx = result.paths[i].args[4];
      cy = result.paths[i].args[5];
      ctx.bezierCurveTo(x1, y1, x2, y2, cx, cy);
      cx1 = x2;
      cy1 = y2;
      break;
    case 'c':
      var x1 = cx + result.paths[i].args[0];
      var y1 = cy + result.paths[i].args[1];
      var x2 = cx + result.paths[i].args[2];
      var y2 = cy + result.paths[i].args[3];
      cx += result.paths[i].args[4];
      cy += result.paths[i].args[5];
      ctx.bezierCurveTo(x1, y1, x2, y2, cx, cy);
      cx1 = x2;
      cy1 = y2;
      break;
    case 'S':
      var x1 = cx;
      var y1 = cy;
      var lk = lastkey.toLowerCase();
      if (lk == 'c' || lk == 's') {
        x1 = 2 * cx - cx1;
        y1 = 2 * cy - cy1;
      }
      var x2 = result.paths[i].args[0];
      var y2 = result.paths[i].args[1];
      cx = result.paths[i].args[2];
      cy = result.paths[i].args[3];
      ctx.bezierCurveTo(x1, y1, x2, y2, cx, cy);
      cx1 = x2;
      cy1 = y2;
      break;
    case 's':
      var x1 = cx;
      var y1 = cy;
      var lk = lastkey.toLowerCase();
      if (lk == 'c' || lk == 's') {
        x1 = 2 * cx - cx1;
        y1 = 2 * cy - cy1;
      }
      var x2 = cx + result.paths[i].args[0];
      var y2 = cy + result.paths[i].args[1];
      cx += result.paths[i].args[2];
      cy += result.paths[i].args[3];
      ctx.bezierCurveTo(x1, y1, x2, y2, cx, cy);
      cx1 = x2;
      cy1 = y2;
      break;
    case 'L':
      cx = result.paths[i].args[0];
      cy = result.paths[i].args[1];
      ctx.lineTo(cx, cy);
      break;
    case 'l':
      cx += result.paths[i].args[0];
      cy += result.paths[i].args[1];
      ctx.lineTo(cx, cy);
      break;
    case 'H':
      cx = result.paths[i].args[0];
      ctx.lineTo(cx, cy);
      break;
    case 'h':
      cx += result.paths[i].args[0];
      ctx.lineTo(cx, cy);
      break;
    case 'V':
      cy = result.paths[i].args[0];
      ctx.lineTo(cx, cy);
      break;
    case 'v':
      cy += result.paths[i].args[0];
      ctx.lineTo(cx, cy);
      break;
    }
    lastkey = key;
  }
  return canvas;
}

